import { z } from "zod";

export const RumSiteVisitsResponseSchema = z.record(
  z.string().refine((date) => !isNaN(Date.parse(date)), {
    message: "Invalid date format",
  }),
  z.number().int().nonnegative()
);

export type RumSiteVisitsResponse = z.infer<typeof RumSiteVisitsResponseSchema>
